---
name: educational-game-mechanics
description: Expert guidance for selecting and applying game mechanics to educational content. Use when designing game-based learning experiences, selecting mechanics for lesson plans, or recommending interactive approaches for teaching specific subjects and skills. Provides access to 189 categorized mechanics with implementation guidance, cognitive skill mapping, and subject-specific applications.
---

# Educational Game Mechanics Selector

This skill provides expert guidance for selecting appropriate game mechanics to enhance educational content across subjects. It helps educators, instructional designers, and content creators match learning objectives with effective game-based interaction patterns.

## When to Use This Skill

Use this skill when:

- Designing game-based learning experiences or educational games
- Selecting game mechanics for specific lesson plans or curricula
- Matching learning objectives to interactive engagement strategies
- Evaluating mechanics for implementation feasibility and educational impact
- Exploring cognitive skills development through gameplay patterns
- Finding mechanics suitable for specific subjects (Mathematics, Science, Language Arts, etc.)
- Identifying mechanics with existing interactive demos for prototyping
- Adapting board game or video game mechanics for educational contexts

## Core Principles for Mechanic Selection

### 1. Learning Objectives First

Always begin by understanding the educational goals:

- **Knowledge acquisition** - What concepts, facts, or procedures should students learn?
- **Skill development** - What cognitive skills need practice (problem-solving, pattern recognition, etc.)?
- **Subject context** - How does this fit within the subject area's pedagogical approach?
- **Assessment needs** - How will student understanding be measured through gameplay?

### 2. Implementation Constraints

Consider practical limitations:

- **Technical feasibility** - Mechanics are rated as EASY, MODERATE, or CHALLENGING to implement
- **Development time** - More complex mechanics require more development resources
- **Platform constraints** - Digital vs. physical, web vs. native app, single vs. multiplayer
- **Audience age/ability** - Cognitive load and interface complexity appropriateness

### 3. Engagement vs. Educational Value

Balance entertainment with learning:

- **High algebra rating** - Direct mathematical/logical problem-solving integration
- **Medium algebra rating** - Strategic thinking with mathematical elements
- **Low algebra rating** - General engagement that can be adapted to various subjects
- Prefer mechanics where the game challenge IS the learning challenge, not separate from it

## Decision Framework

When recommending mechanics, follow this structured approach:

### Step 1: Analyze the Learning Context

Extract and clarify:
- Subject area(s) the content addresses
- Specific learning objectives or skills to develop
- Target cognitive skills (from the mechanics catalog categories)
- Any constraints mentioned (implementation difficulty, platform, time)

### Step 2: Query the Mechanics Database

Access `references/mechanics.json` to find candidates. The JSON structure includes:

```json
{
  "metadata": {
    "total_mechanics": 189,
    "categories": {
      "subject_applications": [...],
      "cognitive_skills": [...],
      "feasibility_levels": ["EASY", "MODERATE", "CHALLENGING"]
    }
  },
  "mechanics": [
    {
      "name": "Mechanic Name",
      "feasibility": "EASY|MODERATE|CHALLENGING",
      "algebra_specific_use": "HIGH|MEDIUM|LOW - description",
      "implementation_notes": "How to implement...",
      "subject_applications": ["Mathematics/Algebra", "Science/STEM", ...],
      "cognitive_skills": ["Problem Solving", "Pattern Recognition", ...]
    }
  ]
}
```

**Search strategies:**
- Grep for subject areas: `grep -i "Mathematics/Algebra" references/mechanics.json`
- Grep for cognitive skills: `grep -i "Strategic Planning" references/mechanics.json`
- Grep for feasibility: `grep "\"feasibility\": \"EASY\"" references/mechanics.json`
- Read the full file for comprehensive analysis of multiple criteria

### Step 3: Evaluate Candidates

For each candidate mechanic, assess:

**Educational Fit:**
- Does the mechanic's core interaction align with the learning objective?
- Are the cognitive skills it develops relevant to the subject?
- Does the algebra rating match the mathematical/logical intensity needed?

**Practical Feasibility:**
- Does the implementation difficulty match available resources?
- Are there existing demos that could accelerate prototyping?
- Can the mechanic scale to the target audience size?

**Pedagogical Soundness:**
- Does gameplay naturally require practicing the target skills?
- Can incorrect understanding be surfaced through gameplay failure?
- Does the mechanic provide opportunities for formative assessment?

### Step 4: Recommend with Rationale

Present recommendations with:
1. **Primary recommendation** - The best-fit mechanic with clear reasoning
2. **Alternative options** - 2-3 other viable candidates with trade-offs explained
3. **Implementation guidance** - Key considerations from the mechanic's notes
4. **Demo availability** - Whether an interactive demo exists for testing

## Interactive Demos

26 mechanics currently have interactive demos showcasing implementation:

**Phase 1 Demos (2):**
- Bingo
- Matching

**Phase 2 Demos (10):**
- Grid Movement, Action Points, Pattern Recognition, Deduction, Connections
- Hand Management, Push Your Luck, Set Collection, Track Movement, Worker Placement

**Phase 3 Demos (8):**
- Memory, Dice Rolling, Threshold, Chaining, Tile Placement
- Melding, Auction/Bidding, Variable Player Powers

**Phase 4 Demos (6):**
- Automatic Resource Growth, Action Queue, Contracts
- Line Drawing, Simulation, Deck Building

When recommending mechanics with demos, mention this advantage for rapid prototyping and stakeholder buy-in.

## Example Workflows

### Workflow 1: Lesson Plan Integration

**User request:** "I'm teaching quadratic equations to high school algebra students. What game mechanic would work well?"

**Process:**
1. **Identify needs:** Quadratic equations (Mathematics/Algebra), problem-solving skills, high school level
2. **Query database:** Search for `"Mathematics/Algebra"` and `"HIGH"` algebra rating
3. **Filter by feasibility:** Consider EASY to MODERATE for typical implementation
4. **Evaluate fit:** Look for mechanics where solving quadratics is the core challenge
5. **Recommend:** Suggest "Tile Placement" (demo available), "Pattern Recognition" (demo available), or "Simulation" (demo available) with rationale for each

### Workflow 2: Cross-Subject Skill Development

**User request:** "I want students to develop strategic planning skills across multiple subjects. What mechanics support this?"

**Process:**
1. **Identify needs:** Strategic Planning cognitive skill, cross-subject applicability
2. **Query database:** Grep for `"Strategic Planning"` in cognitive_skills
3. **Check versatility:** Look for mechanics listed under multiple subject applications
4. **Recommend mechanics:** Present options like "Worker Placement," "Resource Management," or "Deck Building" that develop planning skills transferable across contexts

### Workflow 3: Constrained Implementation

**User request:** "I need a simple game mechanic I can build quickly for teaching vocabulary. I'm not a programmer."

**Process:**
1. **Identify needs:** Language Arts, EASY feasibility, minimal technical complexity
2. **Query database:** Filter by `"feasibility": "EASY"` and `"Language Arts"`
3. **Prioritize demos:** Check which easy mechanics have working demos to reference
4. **Recommend:** Suggest "Bingo" (demo available), "Matching" (demo available), or "Set Collection" (demo available) with implementation starting points

## Tips for Effective Recommendations

1. **Ask clarifying questions** when learning objectives are vague
2. **Suggest multiple options** at different complexity levels when constraints are unclear
3. **Explain trade-offs** between educational depth and implementation ease
4. **Reference demos** as concrete examples when available
5. **Encourage iteration** - mechanics can be simplified or combined based on testing
6. **Consider scaffolding** - starting with simpler mechanics and layering complexity
7. **Think beyond digital** - many mechanics work as physical classroom activities

## Common Pitfalls to Avoid

- **Chocolate-covered broccoli:** Don't bolt games onto content - integrate them
- **Overcomplication:** Simpler mechanics often teach more effectively than complex ones
- **Ignoring cognitive load:** Game rules shouldn't overshadow learning content
- **Mismatched difficulty:** Game challenge and learning challenge should align
- **Single-solution thinking:** Multiple mechanics can often address the same learning goal

## Accessing the Full Database

The complete mechanics catalog is available in `references/mechanics.json`. Read this file when:

- Comprehensive analysis of multiple criteria is needed
- Comparing many mechanics across dimensions simultaneously
- The user requests a broad overview of available options
- Building a suite of mechanics for a full curriculum

For targeted searches, use grep to avoid loading the entire 189-mechanic database unnecessarily.
